#include <iostream>
#include <utility>

using namespace std;
using namespace rel_ops;

class Vektor {
  private:
    double* ap;
    int len;

  public:
    Vektor(int len_ = 0, double x = 0.0) : len(len_) {
      ap = new double[len];
      for (int i = 0; i < len; i++) ap[i] = x;
    }
    ~Vektor() {
      delete[] ap;
    }
    double& operator[](int i) {
      return ap[i];
    }
    double operator[](int i) const {
      return ap[i];
    }

    friend bool operator== (const Vektor& v1, const Vektor& v2) {
      if (v1.len != v2.len) return false;
      for (int i = 0; i < v1.len; i++)
        if (v1[i] != v2[i])
          return false;
      return true;
    }

    friend bool operator< (const Vektor& v1, const Vektor& v2) {
      for (int i = 0; i < v1.len; i++) {
        if (v1[i] > v2[i])
          return false;
        else if (v1[i] < v2[i])
          return true;
      }
      return v1.len < v2.len;
    }
};

int main() {
  Vektor v1{2, 1.0}, v2{3, 1.0};

  cout << boolalpha;

  cout << "v1 < v2:  " << (v1 < v2) << endl
       << "v1 > v2:  " << (v1 > v2) << endl
       << "v1 == v2: " << (v1 == v2) << endl
       << "v1 != v2: " << (v1 != v2) << endl;
  cout << endl;

  v1[1] = 2.0;
  cout << "v1 < v2:  " << (v1 < v2) << endl
       << "v1 > v2:  " << (v1 > v2) << endl
       << "v1 == v2: " << (v1 == v2) << endl
       << "v1 != v2: " << (v1 != v2) << endl;
  cout << endl;

  Vektor v3{3, 1.0};
  cout << "v2 <= v3: " << (v2 <= v3) << endl
       << "v2 >= v3: " << (v2 >= v3) << endl
       << "v2 == v3: " << (v2 == v3) << endl
       << "v2 != v3: " << (v2 != v3) << endl;

  return 0;
}
