#include <iostream>

using namespace std;

class Vektor {
  private:
    double* ap;
    unsigned int len;

  public:
    Vektor(int n = 0, double x = 0) : len(n) {
      ap = new double[n];
      for (int i = 0; i < n; i++) ap[i] = x;
    }
    ~Vektor() { delete[] ap; }

    class iterator {
      friend class Vektor;

      private:
        Vektor* v;
        unsigned int pos;

        iterator(Vektor* v_, unsigned int pos_ = 0)
          : v(v_), pos(pos_) {}

      public:
        double& operator*() {
          return v->ap[pos];
        }
        iterator& operator++() {
          if (pos < v->len) pos++;
          return *this;
        }
        bool operator!=(const iterator& other) const {
          return v != other.v || pos != other.pos;
        }
    };

    iterator begin() { return iterator{this}; }
    iterator end() { return iterator{this, len}; }
};

int main() {
  Vektor v{4};

  cout << "v: ";
  unsigned int count = 0;
  for (Vektor::iterator it = v.begin(); it != v.end(); ++it) {
    *it = count++;
    cout << *it << " ";
  }
  cout << endl;
}
