#include <iostream>

using namespace std;

class Vektor {
  private:
    double* ap;
    int len;

  public:
    Vektor(int n = 0, double x = 0) : len(n) {
      ap = new double[n];
      for (int i = 0; i < n; i++) ap[i] = x;
    }
    Vektor(const Vektor& a) : len(a.len) {
      ap = new double[len];
      for (int i = 0; i < len; i++)
        ap[i] = a.ap[i];
    }
    ~Vektor() { delete[] ap; }

    Vektor& operator=(const Vektor& b) {
      delete[] ap;
      len = b.len;
      ap = new double[len];
      for (int i = 0; i < len; i++)
        ap[i] = b.ap[i];
      return *this;
    }

    friend ostream& operator<<(ostream& aus, const Vektor& v) {
      for (int i = 0; i < v.len; i++) {
        if (i != 0) aus << " ";
        aus << v.ap[i];
      } return aus;
    }

    double& at(int i) { return ap[i]; }
};

int main() {
  int n; cout << "n: "; cin >> n;
  Vektor a(n); cout << "a[0] ... a[" << (n - 1) << "]: ";
  for (int i = 0; i < n; i++) cin >> a.at(i);

  Vektor b, c{a};
  b = a;

  a.at(0) = b.at(n - 1) = 7;

  cout << "a: " << a << ", " << "b: " << b << ", " << "c: " << c << endl;
}
