#include <iostream>

using namespace std;

class Vektor3D {
  public:
    double x, y, z;
    Vektor3D(double x_ = 0, double y_ = 0, double z_ = 0) : x(x_), y(y_), z(z_) {}
};

Vektor3D operator+(const Vektor3D& a, const Vektor3D& b) {
  Vektor3D c;
  c.x = a.x + b.x;
  c.y = a.y + b.y;
  c.z = a.z + b.z;
  return c;
}

Vektor3D& operator+=(Vektor3D& a, const Vektor3D& b) {
  a.x += b.x;
  a.y += b.y;
  a.z += b.z;
  return a;
}

Vektor3D& operator*=(Vektor3D& a, double lambda) {
  a.x *= lambda;
  a.y *= lambda;
  a.z *= lambda;
  return a;
}

Vektor3D operator*(const Vektor3D& a, double lambda) {
  Vektor3D b{a};
  return b *= lambda;
}

Vektor3D operator*(double lambda, const Vektor3D& a) {
  return a * lambda;
}

Vektor3D operator^(const Vektor3D& a, const Vektor3D& b) {
  Vektor3D c;
  c.x = a.y*b.z - a.z*b.y;
  c.y = a.z*b.x - a.x*b.z;
  c.z = a.x*b.y - a.y*b.x;
  return c;
}

ostream& operator<<(ostream& stream, const Vektor3D& a) {
  return stream << "(" << a.x << "," << a.y << "," << a.z << ")";
}

istream& operator>>(istream& stream, Vektor3D& a) {
  char c1, c2, c3, c4;
  stream >> c1 >> a.x >> c2 >> a.y >> c3 >> a.z >> c4;
  if (c1 != '(' || c2 != ',' || c3 != ',' || c4 != ')')
    stream.setstate(ios::failbit);
  return stream;
}

int main() {
  Vektor3D a, b;
  cout << "a: "; cin >> a;
  cout << "b: "; cin >> b;

  Vektor3D c = a ^ b;
  cout << "c = " << c << endl;

  c += (a *= 2) ^ b;
  cout << "a = " << a << endl
       << "b = " << b << endl
       << "c = " << c << endl;

  return 0;
}
