#include <iostream>
#include <iomanip>
#include <cctype>

using namespace std;

int strtoint(string s, unsigned int basis = 10) {
  if (s.size() <= 0 || basis < 2 || basis >= 36)
    return -1;

  int zahl = 0;
  for (unsigned int i = 0; i < s.size(); i++) {
    unsigned int ziffer;

    if (isdigit(s[i]))
      ziffer = s[i] - '0';
    else if (islower(s[i]))
      ziffer = s[i] - 'a' + 10;
    else if (isupper(s[i]))
      ziffer = s[i] - 'A' + 10;
    else
      return -1;

    if (ziffer < 0 || ziffer >= basis)
      return -1;

    zahl = basis*zahl + ziffer;
  }

  return zahl;
}

int main() {
  string s;
  cout << "s: ";
  cin >> s;

  cout << "Wert in dezimal:     " << strtoint(s)     << endl
       << "Wert in hexadezimal: " << strtoint(s, 16) << endl;

  return 0;
}
