#include <iostream>
#include <iomanip>
#include <limits>

#include "pnorms.h"

using namespace std;

int main() {
  double bound = pnorm_bound<double, 2, 3>();

  cout << setprecision(numeric_limits<double>::digits10 + 1) << boolalpha;
  cout << bound << endl;

  double real_, imag_;
  while (true) {
    cout << "real, imag = ";
    if (!(cin >> real_ >> imag_)) break;

    double val = pnorm_bound<double, 2, 3>(complex<double>{real_, imag_});
    cout << val << " " << (val <= bound) << endl;
  }

}
