#include <iostream>
#include <iomanip>
#include <limits>
#include <array>
#include <vector>
#include <cstddef>
#include <cmath>

using namespace std;

template<class Vec, unsigned int p = 2>
  class PNorm{
    private:
      using X = typename Vec::value_type;
    public:
      X operator()(const Vec& v) {
        X x = 0;
        for (const X& y: v)
          x += pow(y, p);
        return pow(x, static_cast<X>(1) / p);
      }
  };

template<class Vec>
  class PNorm<Vec, 2>{
    private:
      using X = typename Vec::value_type;
    public:
      X operator()(const Vec& v) {
        X x = 0;
        for (const X& y: v)
          x += y * y;
        return sqrt(x);
      }
  };

int main() {
  vector<double> c{5, 6};
  array<float, 2> a{3, 4};

  cout
    << setprecision(numeric_limits<double>::digits10 + 1)
    << PNorm<vector<double>>{}(c) << endl
    << PNorm<array<float, 2>, 3>{}(a) << endl;
}
