#include <iostream>
#include <iomanip>
#include <cmath>

using namespace std;

class NormV {
  private:
    double mw, stdabw;

  public:
    NormV (double mw_ = 0, double stdabw_ = 1)
      : mw(mw_), stdabw(stdabw_) {}

    double operator()(double x) const {
      return M_2_SQRTPI / (2 * M_SQRT2 * stdabw)
        * exp(-((x - mw) * (x - mw)) / (2*stdabw*stdabw));
    }
};

int main() {
  NormV n{0, 2};
  for (double x = -6; x <= 6.001; x += 12. / 18) {
    double fx = n(x);
    cout << setw(5) << fixed << setprecision(3) << fx << ' ';
    for (int k = 1; k < fx * 200; k++) cout << '#';
    cout << endl;
  }

  cout << endl;

  cout << defaultfloat << setprecision(6)
       << NormV{}(-0.5) << endl;
}
