#include <iostream>
#include <iomanip>
#include <valarray>

using namespace std;

gslice submatrix(size_t mp, size_t np, size_t n)
  { return gslice(0, {mp, np}, {n, 1}); }

void ausgabe_matrix(const valarray<double>& a, size_t n) {
  for (size_t k = 0; k < a.size(); k++) {
    cout << setw(3) << a[k];
    if ((k+1) % n == 0)
      cout << endl;
  }
}

int main() {
  size_t m, n, mp, np;
  cout << "m n: "; cin >> m >> n;
  cout << "mp np: "; cin >> mp >> np;

  valarray<double> a(m*n);
  for (size_t k = 0; k < a.size(); k++) a[k] = k;

  cout << "a:" << endl;
  ausgabe_matrix(a, n); cout << endl;

  cout << "sub a:" << endl;
  ausgabe_matrix(a[submatrix(mp, np, n)], np); cout << endl;
}
