#include <iostream>

using namespace std;

class Complex {
  private:
    double re, im;

  public:
    Complex (double re_ = 0, double im_ = 0) : re(re_), im(im_) {}

    double real() const { return re; }
    double imag() const { return im; }

    friend Complex& operator++(Complex& z) {
      z.re++;
      return z;
    }
    friend Complex operator++(Complex& z, int ignored) {
      return Complex{z.re++, z.im};
    }

    friend Complex& operator--(Complex& z) {
      z.re--;
      return z;
    }
    friend Complex operator--(Complex& z, int ignored) {
      return Complex{z.re--, z.im};
    }
};

int main() {
  Complex z{2.0, 3.0};

  cout << (z++).real() << endl
       << z.real()     << endl
       << (++z).real() << endl
       << z.real()     << endl;
  cout << endl;

  cout << (z--).real() << endl
       << z.real()     << endl
       << (--z).real() << endl
       << z.real()     << endl;

  return 0;
}
