#include <iostream>

using namespace std;

class A {
  protected:
    double x;

  public:
    A(double x_) : x(x_) {}
};

class B : public A {
  private:
    int approx_x;

  public:
    B(double x_) : A(x_), approx_x(x_) {}

    friend ostream& operator<<(ostream& stream, const B& b) {
      return stream << b.x << " =~ " << b.approx_x;
    }
};

int main() {
  B b1{3.0}, b2{7.0};
  A& ap = b1;
  ap = b2;

  cout << b1 << endl;
}
