#include <iostream>
#include <iomanip>

using namespace std;

bool is_delim(char c, const char* del) {
  for (int i = 0; del[i] != '\0'; i++)
    if (del[i] == c)
      return true;
  return false;
}
int strspn(const char* str, const char* del) {
  int res = 0;
  while (str[res] != '\0')
    if (is_delim(str[res], del))
      res++;
    else
      return res;
  return res;
}
int strcspn(const char* str, const char* del) {
  int res = 0;
  while (str[res] != '\0')
    if (!is_delim(str[res], del))
      res++;
    else
      return res;
  return res;
}

char* strtok(char* str, const char* del) {
  static char* buffer;
  if (str)
    buffer = str;

  buffer += strspn(buffer, del);

  if (*buffer == '\0')
    return nullptr;

  char* tokenBegin = buffer;

  buffer += strcspn(buffer, del);
  if (*buffer != '\0')
    *(buffer++) = '\0';

  return tokenBegin;
}

int main() {
  char input[] = "one + two * (three - four)!";
  const char delim[] = "! +- (*)";
  for (char* token = strtok(input, delim); token; token = strtok(nullptr, delim))
    cout << '"' << token << '"' << endl;
}
