#pragma once

#include <complex>

template<class T = double, unsigned int p = 2>
  T pNorm(const std::complex<T>& z);

template<class T = double, T _norm(const std::complex<T>&) = pNorm<T>>
  class complex_norm : public std::complex<T> {
    public:
      complex_norm(T real_, T imag_);
      T norm() const;
};

template<class T = double, unsigned int p = 2>
  using complex_pnorm = complex_norm<T, pNorm<T, p>>;

template<class T = double, unsigned int p1, unsigned int p2>
  T pnorm_bound(std::complex<T> = std::complex<T>{1.0, 1.0});
