#include <iostream>
#include <iomanip>
#include <valarray>
#include <algorithm>

using namespace std;

void ausgabe_vektor(const valarray<double>& a) {
  for (double x: a)
    cout << setw(3) << x;
}
void ausgabe_matrix(const valarray<double>& a, size_t n) {
  for (size_t k = 0; k < a.size(); k++) {
    cout << setw(3) << a[k];
    if ((k+1) % n == 0)
      cout << endl;
  }
}

int main() {
  size_t m, n;
  cout << "m n: "; cin >> m >> n;

  valarray<double> a(m*n);

  for (size_t k = 0; k < a.size(); k++) a[k] = k;

  valarray<bool> bv(m*n);
  bv = false;
  bv[0] = bv[n - 1] = bv[n * (m-1)] = bv[m*n - 1] = true;
  a[bv] = 0;
  cout << "a:" << endl;
  ausgabe_matrix(a, n); cout << endl;

  valarray<size_t> iv(min(m, n));
  for (size_t i = 0; i < min(m, n); i++)
    iv[i] = i*(n + 1);
  cout << "diag(a):";
  ausgabe_vektor(a[iv]); cout << endl;
}
