#include <iostream>
#include <iomanip>

#include "matrix.h"

using namespace std;

int main() {
  size_t m, n;
  cout << "m n: "; cin >> m >> n;
  matrix<double> a{m, n};
  cout << "Matrix a: " << endl;
  for (double& x: a) cin >> x;
  cout << endl;

  size_t k, l;
  cout << "k l: "; cin >> k >> l;
  matrix<double> b{k, l};
  cout << "Matrix b: " << endl;
  for (double& x: b) cin >> x;
  cout << endl;

  matrix<double> c{m, l};
  for (size_t i = 0; i < m; i++)
    for (size_t j = 0; j < l; j++) {
      valarray<double> as = a.row(i), bs = b.column(j);
      c[i][j] = (as * bs).sum();
    }

  for (size_t i = 0; i < m; i++) {
    for (size_t j = 0; j < l; j++)
      cout << setw(3) << c[i][j];
    cout << endl;
  }
}
