#include <map>
#include <string>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <vector>
#include <algorithm>

using namespace std;

bool ordnung(const pair<string, int>& a,
  const pair<string, int>& b) {
    return a.second > b.second;
}

int main(int argc, char* argv[]) {
  map<string, int> freq;
  int nwort = 0;

  ifstream ein(argv[1]);
  string wort;
  while (ein >> wort) {
    nwort++;
    freq[wort]++;
  }

  vector<pair<string, int>> vektor(freq.begin(), freq.end());
  stable_sort(vektor.begin(), vektor.end(), ordnung);

  int count = 0;
  for (auto entry: vektor) {
    cout << setw(10) << entry.first
         << setw(5) << entry.second
         << endl;
    if (++count >= 10) break;
  }

  cout << endl << "Wortzahl: " << setw(8) << nwort << endl;

  return 0;
}
