#include <iostream>
#include <list>
#include <functional>
#include <algorithm>
#include <numeric>

using namespace std;

void f(double& sum, double x) { sum += x; }

double g(int& count, double prev, double x) {
  int ncount = count + 1;
  double next = (prev * count + x) / ncount;
  count = ncount;
  return next;
}

int main() {
  list<double> vals;
  double x;
  while (cout << "x: ", cin >> x)
    vals.push_back(x);

  double sum = 0;
  using namespace placeholders;
  for_each(vals.begin(), vals.end(), bind(f, ref(sum), _1));
  cout << "MW (for_each):   " << (sum / vals.size()) << endl;

  int count = 0;
  double mean = accumulate(vals.begin(), vals.end(),
    0.0, bind(g, ref(count), _1, _2));
  cout << "MW (accumulate): " << mean << endl;
}
