#include <iostream>
#include <array>
#include <cstddef>
#include <cmath>

using namespace std;

template<class T = double, unsigned int p = 2, size_t dim>
  T pNorm(const array<T, dim>& v) {
    T x = 0;
    for (const T& y: v)
      x += pow(y, p);
    return pow(x, static_cast<T>(1) / p);
}

template<>
  double pNorm<double, 2, 3>(const array<double, 3>& v) {
    return sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
}

int main() {
  array<double, 3> a1{1, 2, 3};
  cout << pNorm<double, 2, 3>(a1) << endl;

  array<double, 5> a2{5, 4, 3, 2, 1};
  cout << pNorm<double, 3>(a2) << endl;
}
